<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Carousel extends MY_Controller {
	public function __construct(){
        parent::__construct();
        $this->load->helper('url'); 
		$this->load->model('carousel_model');
		$this->load->model('setting_model');
		$this->load->model('user_model');
        $this->load->library('form_validation');
		
		// Check Session Login
		if(!isset($_SESSION['logged_in'])){
			redirect(site_url('auth/login'));
		}
	}
	
	public function index(){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		if(isset($_GET['search'])){
			$filter = array();
            if(!empty($_GET['id']) && $_GET['id'] != ''){
                if (is_numeric($_GET['id'])){
					$filter['carousel.id ='] = $_GET['id'];
				}else{
				    $filter['carousel.title' . ' LIKE'] = "%" . $_GET['id'] . "%";
            }
			}

			$total_row = $this->carousel_model->count_total_filter($filter);
			$data['carousels'] = $this->carousel_model->get_filter($filter,url_param());
		}else{
			$total_row = $this->carousel_model->count_total();
			$data['carousels'] = $this->carousel_model->get_all(url_param());
		}
		$data['paggination'] = get_paggination($total_row,get_search());

		$this->load->view('carousel/index',$data);
	}
	
	public function create(){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		$code_carousel = $this->carousel_model->get_last_id();
		$this->load->view('carousel/form',$data);
	}

	public function edit($id = ''){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		$check_id = $this->carousel_model->get_by_id($id);
		if($check_id){
			$data['carousel'] = $check_id[0];
			$this->load->view('carousel/form',$data);
		}else{
			redirect(site_url('carousel'));
		}
	}

	public function save($id = ''){

		$data['type'] = '-';
		// $data['file'] = $this->input->post('file');
		$data['title'] = $this->input->post('title');
		$data['link'] = $this->input->post('link');

        $type = $data['type'];
        $title = $data['title'];
        $link = $data['link'];

        $check_id = $this->carousel_model->get_by_id($id);
        if($check_id) {

            $config['upload_path'] = './upload/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $config['max_size'] = '5000';
            $config['remove_spaces'] = TRUE;
            $config['encrypt_name'] = TRUE;
    
            $this->load->library('upload', $config);
    
            if ( ! $this->upload->do_upload('files')){
                $data = array(
                    'type' => $type[0],
                    'title' => $title[0],
                    'link' => $link[0],
                );
                $this->carousel_model->update($id,$data);
            }else{
                $file_up = $check_id[0]['file'];
                $path_to_file = './upload/'.$file_up;
                unlink($path_to_file);
                $uploadData = $this->upload->data();
                $filename = $uploadData['file_name'];
                $data = array(
                    'type' => $type[0],
                    'title' => $title[0],
                    'link' => $link[0],
                    'file' => $filename,
                );
                $this->carousel_model->update($id,$data);
            }
		    redirect(site_url('carousel'));
        } else {
        $data = [];
        
            $count = count($_FILES['files']['name']);
            
            for($i=0;$i<$count;$i++){
            
                if(!empty($_FILES['files']['name'][$i])){
            
                $_FILES['file']['name'] = $_FILES['files']['name'][$i];
                $_FILES['file']['type'] = $_FILES['files']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                $_FILES['file']['error'] = $_FILES['files']['error'][$i];
                $_FILES['file']['size'] = $_FILES['files']['size'][$i];
        
                $config['upload_path'] = './upload/'; 
                $config['allowed_types'] = 'jpg|jpeg|png|gif';
                $config['max_size'] = '5000';
                $config['remove_spaces'] = TRUE;
                $config['encrypt_name'] = TRUE;
                $config['file_name'] = $_FILES['files']['name'][$i];

                $this->load->library('upload',$config); 
            
                if($this->upload->do_upload('file')){
                    $uploadData = $this->upload->data();
                    $filename = $uploadData['file_name'];
                    $data = array(
                        'type' => $type[$i],
                        'title' => $title[$i],
                        'link' => $link[$i],
                        'file' => $filename
                    );
                    $this->db->insert('carousel',$data);
                    // echo json_encode($data);
                    // $data['totalFiles'][] = $filename;
                    // echo json_encode($filename);
                }else{
                    $data = array(
                        'type' => $type[$i],
                        'title' => $title[$i],
                        'link' => $link[$i],
                    );
                    $this->db->insert('carousel',$data);
                }
                }
        
            }
		    redirect(site_url('carousel'));
	    }
    }
	public function delete($id){
		$check_id = $this->carousel_model->get_by_id($id);
		if($check_id){
            $file_up = $check_id[0]['file'];
            $path_to_file = './upload/'.$file_up;
            unlink($path_to_file);
			$this->carousel_model->delete($id);
		}
		redirect(site_url('carousel'));
	}
	public function export_csv(){
		$filter = false;
		if(isset($_GET['search'])) {
			$filter = array();
			if (!empty($_GET['value']) && $_GET['value'] != '') {
				$filter[$_GET['search_by'] . ' LIKE'] = "%" . $_GET['value'] . "%";
			}
		}
		$data = $this->carousel_model->get_all_array($filter);
		$this->csv_library->export('carousel.csv',$data);
	}
}
