var listGameEl = document.getElementById('listGame');

listGameEl.innerHTML = '';
listGameData.map(function (item, index) {
	listGameEl.innerHTML += `
	<div class="list-game__item game-item" data-game-index="${index}">
		<a class="game-item__img-wrap" href="${item.link}" target="_blank" rel="noopener noreferrer">
		<img class="game-item__img lazyload" data-src="${item.image}" alt=""/>
		<div class="game-item__hover">
			<div class="game-item__button">
			PLAY NOW
			</div>
		</div>
		</a>
		<div class="percent__wrap">
			<div class="percent">
				<div class="percent__value">${item.percent}%</div>
				<div class="percent__bar ${item.color}" style="width: ${item.percent}%;"></div>
			</div>
		</div>
	</div>
	`;
});

var searchGameInput = document.getElementById('searchGame');

function filterGames(evt) {
	var searchKey = evt.target.value.toLowerCase();

	var listGame = document.getElementsByClassName('list-game__item');

	for (var i = 0; i < listGame.length; i++) {
		var gameName = listGame[i].querySelector('.game-item__name').innerText.toLowerCase();
		var regexSearchName = new RegExp(searchKey, 'g');
		var found = regexSearchName.test(gameName);

		if (found) {
			listGame[i].classList.remove("list-game__item--hidden")
		} else {
			listGame[i].classList.add("list-game__item--hidden")
		}
	}
}

searchGameInput.addEventListener('change', filterGames);
searchGameInput.addEventListener('keyup', filterGames);

setTimeout(function () {
	updatePercent()
}, 5000)